/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.plugin.java;

import com.google.common.io.ByteStreams;
import cpw.mods.modlauncher.EnumerationHelper;
import io.izzel.tools.product.Product2;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.security.CodeSource;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;
import org.apache.commons.lang3.Validate;
import org.bukkit.plugin.InvalidPluginException;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.SimplePluginManager;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.plugin.java.JavaPluginLoader;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.magmafoundation.magma.Magma;
import org.magmafoundation.magma.patcher.Patcher;
import org.magmafoundation.magma.remapping.ClassLoaderRemapper;
import org.magmafoundation.magma.remapping.MagmaRemapper;
import org.magmafoundation.magma.remapping.loaders.RemappingClassLoader;
import org.magmafoundation.magma.util.JavaPluginLoaderBridge;

final class PluginClassLoader
extends URLClassLoader
implements RemappingClassLoader {
    private final JavaPluginLoader loader;
    private final Map<String, Class<?>> classes = new ConcurrentHashMap();
    private final PluginDescriptionFile description;
    private final File dataFolder;
    private final File file;
    private final JarFile jar;
    private final Manifest manifest;
    private final URL url;
    private final ClassLoader libraryLoader;
    final JavaPlugin plugin;
    private JavaPlugin pluginInit;
    private IllegalStateException pluginState;
    private final Set<String> seenIllegalAccess = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Patcher patcher;
    private ClassLoaderRemapper remapper;

    PluginClassLoader(@NotNull JavaPluginLoader loader, @Nullable ClassLoader parent, @NotNull PluginDescriptionFile description, @NotNull File dataFolder, @NotNull File file, @Nullable ClassLoader libraryLoader) throws IOException, InvalidPluginException, MalformedURLException {
        super(new URL[]{file.toURI().toURL()}, parent);
        Validate.notNull((Object)loader, (String)"Loader cannot be null", (Object[])new Object[0]);
        this.loader = loader;
        this.description = description;
        this.dataFolder = dataFolder;
        this.file = file;
        this.jar = new JarFile(file);
        this.manifest = this.jar.getManifest();
        this.url = file.toURI().toURL();
        this.libraryLoader = libraryLoader;
        this.patcher = Magma.getInstance().getPatcherManager().getPatchByName(description.getName());
        try {
            Class<JavaPlugin> pluginClass;
            Class<?> jarClass;
            try {
                jarClass = Class.forName(description.getMain(), true, this);
            }
            catch (ClassNotFoundException ex) {
                throw new InvalidPluginException("Cannot find main class `" + description.getMain() + "'", ex);
            }
            try {
                pluginClass = jarClass.asSubclass(JavaPlugin.class);
            }
            catch (ClassCastException ex) {
                throw new InvalidPluginException("main class `" + description.getMain() + "' does not extend JavaPlugin", ex);
            }
            this.plugin = pluginClass.newInstance();
        }
        catch (IllegalAccessException ex) {
            throw new InvalidPluginException("No public constructor", ex);
        }
        catch (InstantiationException ex) {
            throw new InvalidPluginException("Abnormal plugin type", ex);
        }
    }

    @Override
    public URL getResource(String name) {
        Objects.requireNonNull(name);
        URL url = this.findResource(name);
        if (url == null && this.getParent() != null) {
            url = this.getParent().getResource(name);
        }
        return url;
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        Objects.requireNonNull(name);
        Enumeration[] tmp = new Enumeration[2];
        if (this.getParent() != null) {
            tmp[1] = this.getParent().getResources(name);
        }
        tmp[0] = this.findResources(name);
        return EnumerationHelper.merge((Enumeration)tmp[0], (Enumeration)tmp[1]);
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        return this.loadClass0(name, resolve, true, true);
    }

    Class<?> loadClass0(@NotNull String name, boolean resolve, boolean checkGlobal, boolean checkLibraries) throws ClassNotFoundException {
        try {
            Class<?> result = super.loadClass(name, resolve);
            if (checkGlobal || result.getClassLoader() == this) {
                return result;
            }
        }
        catch (ClassNotFoundException result) {
            // empty catch block
        }
        if (checkLibraries && this.libraryLoader != null) {
            try {
                return this.libraryLoader.loadClass(name);
            }
            catch (ClassNotFoundException result) {
                // empty catch block
            }
        }
        if (checkGlobal && (result = this.loader.getClassByName(name, resolve, this.description)) != null) {
            PluginDescriptionFile provider;
            if (result.getClassLoader() instanceof PluginClassLoader && (provider = ((PluginClassLoader)result.getClassLoader()).description) != this.description && !this.seenIllegalAccess.contains(provider.getName()) && !((SimplePluginManager)this.loader.server.getPluginManager()).isTransitiveDepend(this.description, provider)) {
                this.seenIllegalAccess.add(provider.getName());
                if (this.plugin != null) {
                    this.plugin.getLogger().log(Level.WARNING, "Loaded class {0} from {1} which is not a depend or softdepend of this plugin.", new Object[]{name, provider.getFullName()});
                } else {
                    this.loader.server.getLogger().log(Level.WARNING, "[{0}] Loaded class {1} from {2} which is not a depend or softdepend of this plugin.", new Object[]{this.description.getName(), name, provider.getFullName()});
                }
            }
            return result;
        }
        throw new ClassNotFoundException(name);
    }

    @Override
    public Class<?> findClass(String name) throws ClassNotFoundException {
        return this.findClass(name, true);
    }

    Class<?> findClass(String name, boolean checkGlobal) throws ClassNotFoundException {
        if (name.startsWith("org.bukkit.") || name.startsWith("net.minecraft.")) {
            throw new ClassNotFoundException(name);
        }
        Class<?> result = this.classes.get(name);
        if (result == null) {
            String path = name.replace('.', '/').concat(".class");
            URL url = this.findResource(path);
            JarEntry entry = this.jar.getJarEntry(path);
            if (url != null && entry != null) {
                Product2<byte[], CodeSource> classBytes;
                block11: {
                    String pkgName;
                    Callable<byte[]> byteSource;
                    URLConnection connection;
                    try {
                        connection = url.openConnection();
                        connection.connect();
                        byteSource = () -> {
                            try (InputStream is = connection.getInputStream();){
                                byte[] classBytes = ByteStreams.toByteArray((InputStream)is);
                                classBytes = this.loader.server.getUnsafe().processClass(this.description, path, classBytes);
                                if (this.patcher != null) {
                                    classBytes = this.patcher.transform(name.replace("/", "."), classBytes);
                                }
                                byte[] byArray = classBytes;
                                return byArray;
                            }
                        };
                    }
                    catch (IOException e) {
                        throw new ClassNotFoundException(name, e);
                    }
                    classBytes = this.getRemapper().remapClass(name, byteSource, connection);
                    int dot = name.lastIndexOf(46);
                    if (dot != -1 && this.getPackage(pkgName = name.substring(0, dot)) == null) {
                        try {
                            if (this.manifest != null) {
                                this.definePackage(pkgName, this.manifest, this.url);
                            } else {
                                this.definePackage(pkgName, null, null, null, null, null, null, null);
                            }
                        }
                        catch (IllegalArgumentException ex) {
                            if (this.getPackage(pkgName) != null) break block11;
                            throw new IllegalStateException("Cannot find package " + pkgName);
                        }
                    }
                }
                result = this.defineClass(name, (byte[])classBytes._1, 0, ((byte[])classBytes._1).length, (CodeSource)classBytes._2);
            }
            if (result == null) {
                result = super.findClass(name);
            }
            ((JavaPluginLoaderBridge)this.loader).bridge$setClass(name, result);
            this.classes.put(name, result);
        }
        return result;
    }

    @Override
    public void close() throws IOException {
        try {
            super.close();
        }
        finally {
            this.jar.close();
        }
    }

    @NotNull
    Collection<Class<?>> getClasses() {
        return this.classes.values();
    }

    synchronized void initialize(@NotNull JavaPlugin javaPlugin) {
        Validate.notNull((Object)javaPlugin, (String)"Initializing plugin cannot be null", (Object[])new Object[0]);
        Validate.isTrue((javaPlugin.getClass().getClassLoader() == this ? 1 : 0) != 0, (String)"Cannot initialize plugin outside of this class loader", (Object[])new Object[0]);
        if (this.plugin != null || this.pluginInit != null) {
            throw new IllegalArgumentException("Plugin already initialized!", this.pluginState);
        }
        this.pluginState = new IllegalStateException("Initial initialization");
        this.pluginInit = javaPlugin;
        javaPlugin.init(this.loader, this.loader.server, this.description, this.dataFolder, this.file, this);
    }

    @Override
    public ClassLoaderRemapper getRemapper() {
        if (this.remapper == null) {
            this.remapper = MagmaRemapper.createClassLoaderRemapper(this);
        }
        return this.remapper;
    }

    static {
        ClassLoader.registerAsParallelCapable();
    }
}

